<?php
session_start();
include '../config/database.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $contact = trim($_POST['contact']);
    $department = trim($_POST['department']);
    $username = trim($_POST['username']);
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirmPassword'];
    $staff_id = !empty($_POST['staff_id']) ? trim($_POST['staff_id']) : null; // Optional
    $car_number = !empty($_POST['car_number']) ? trim($_POST['car_number']) : null; // Optional

    // Validate required fields
    if (empty($name) || empty($contact) || empty($department) || empty($username) || empty($password)) {
        $error = "Please fill in all required fields.";
    } elseif ($password !== $confirmPassword) {
        $error = "Passwords do not match.";
    } else {
        // Hash the password
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        try {
            // Check if username already exists
            $stmt = $pdo->prepare("SELECT id FROM lecturer_login WHERE username = ?");
            $stmt->execute([$username]);
            if ($stmt->fetch()) {
                $error = "Username already exists.";
            } else {
                // Insert lecturer details
                $stmt = $pdo->prepare("
                    INSERT INTO lecturer_login (name, contact, department, username, password, staff_id, car_number)
                    VALUES (?, ?, ?, ?, ?, ?, ?)
                ");
                $stmt->execute([$name, $contact, $department, $username, $hashedPassword, $staff_id, $car_number]);

                // Success message
                $success = "Lecturer registered successfully.";
            }
        } catch (PDOException $e) {
            $error = "A database error occurred. Please try again.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Signup</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
    <style>
        html, body {
            height: 100%;
            margin: 0;
        }
        .wrapper {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .content {
            flex: 1;
        }
    </style>
</head>
<body>
    <div class="wrapper">
        <div class="content">
            <div class="container mt-5 d-flex justify-content-center">
                <div class="card w-100" style="max-width: 600px;">
                    <div class="card-header">
                        <h2>Admin: Signup Lecturer</h2>
                    </div>
                    <div class="card-body">
                        <!-- Display success or error messages -->
                        <?php if (isset($error)): ?>
                            <div class="alert alert-danger">
                                <?php echo htmlspecialchars($error); ?>
                            </div>
                        <?php elseif (isset($success)): ?>
                            <div class="alert alert-success">
                                <?php echo htmlspecialchars($success); ?>
                            </div>
                        <?php endif; ?>

                        <!-- Signup form -->
                        <form method="POST" action="" autocomplete="off">
                            <div class="mb-3">
                                <label for="name" class="form-label">Full Name</label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                            <div class="mb-3">
                                <label for="contact" class="form-label">Contact</label>
                                <input type="text" class="form-control" id="contact" name="contact" required>
                            </div>
                            <div class="mb-3">
                                <label for="department" class="form-label">Department</label>
                                <select class="form-control" id="department" name="department" required>
                                    <option value="">Select Department</option>
                                    <option value="Management Sciences">Management Sciences</option>
                                    <option value="Applied Finance">Applied Finance</option>
                                    <option value="Accounting">Accounting</option>
                                    <option value="Procurement">Procurement</option>
                                    <option value="Marketing">Marketing</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label for="staff_id" class="form-label">Staff ID (Optional)</label>
                                <input type="text" class="form-control" id="staff_id" name="staff_id" placeholder="Leave blank if unavailable">
                            </div>
                            <div class="mb-3">
                                <label for="car_number" class="form-label">Car Number (Optional)</label>
                                <input type="text" class="form-control" id="car_number" name="car_number" placeholder="Leave blank if unavailable">
                            </div>
                            <div class="mb-3">
                                <label for="username" class="form-label">Username</label>
                                <input type="text" class="form-control" id="username" name="username" required>
                            </div>
                            <div class="mb-3">
                                <label for="password" class="form-label">Password</label>
                                <input type="password" class="form-control" id="password" name="password" required>
                            </div>
                            <div class="mb-3">
                                <label for="confirmPassword" class="form-label">Confirm Password</label>
                                <input type="password" class="form-control" id="confirmPassword" name="confirmPassword" required>
                            </div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-user-plus"></i> Signup
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
