<?php
session_start();
ob_start(); // Start output buffering

if (!isset($_SESSION['lecturer_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php'; // Make sure no output is generated in this included file

$lecturerLoginId = htmlspecialchars($_SESSION['lecturer_id'], ENT_QUOTES, 'UTF-8');
$preferenceId = htmlspecialchars($_GET['id'], ENT_QUOTES, 'UTF-8');

try {
    $stmt = $pdo->prepare('DELETE FROM lecturer_preferences WHERE id = ? AND lecturer_id = ?');
    $stmt->execute([$preferenceId, $lecturerLoginId]);
    $_SESSION['success'] = 'Preference deleted successfully.';
    
    ob_end_clean(); // Clear the output buffer before the redirection
    header('Location: region.php');
    exit;
} catch (PDOException $e) {
    $_SESSION['error'] = 'Error deleting preference: ' . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
    
    ob_end_clean(); // Clear the output buffer before the redirection
    header('Location: region.php');
    exit;
}
?>
