<?php
session_start();

$request = $_SERVER['REQUEST_URI'];
$base_path = '/ims/'; // Adjust if your project is not in the root directory

// Remove the base path from the request URI
$request = str_replace(htmlspecialchars($base_path, ENT_QUOTES, 'UTF-8'), '', $request);

// Remove leading slash if present
$request = ltrim(htmlspecialchars($request, ENT_QUOTES, 'UTF-8'), '/');

$path = parse_url($request, PHP_URL_PATH);

// Define public pages
$public_pages = [
    'welcome', 'student/register', 'student/login', 'student/login_action', 
    'lecturer/login', 'lecturer/signup', 'lecturer/signup_action', 
    'help/index', 'help/login'
];

// Redirect to welcome page if path is empty
if ($path === '') {
    header('Location: /ims/welcome');
    exit;
}

// Check if the user is logged in for protected pages
if (!in_array($path, $public_pages) && !isset($_SESSION['user_id'])) {
    header('Location: /ims/student/login');
    exit;
}

// Check for admin routes
$admin_pages = [
    'admin', 'admin/login', 'admin/logout', 'admin/approve_transfer', 'admin/assign_districts',
    'admin/assign_lecturers', 'admin/assign_students', 'admin/manage_lecturers', 
    'admin/reject_transfer', 'admin/send_sms', 'admin/teaching', 
    'admin/transfers', 'admin/view_lecturers', 'admin/view_student',
    'admin/download_pdf', 'admin/view_pdf', 'admin/fetch_assigned_districts', 
    'admin/fetch_districts', 'admin/fetch_mapping', 'admin/grant_permission', 
    'admin/return_mapping', 'admin/sub_map', 'admin/try'
];

if (in_array($path, $admin_pages) && (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin')) {
    header('Location: /ims/admin/login');
    exit;
}

switch ($path) {
    case 'welcome':
        require __DIR__ . '/welcome.php';
        break;
    // Student routes
    case 'student':
    case 'student/':
        require __DIR__ . '/student/index.php';
        break;
    case 'student/dashboard':
        require __DIR__ . '/student/dashboard.php';
        break;
    case 'student/register':
        require __DIR__ . '/student/register.php';
        break;
    case 'student/login':
        require __DIR__ . '/student/login.php';
        break;
    case 'student/login_action':
        require __DIR__ . '/student/login_action.php';
        break;
    case 'student/save_student_details':
        require __DIR__ . '/student/save_student_details.php';
        break;
    case 'student/fetch_districts':
        require __DIR__ . '/student/fetch_districts.php';
        break;
    case 'student/download_evaluation':
        require __DIR__ . '/student/download_evaluation.php';
        break;
    case 'student/view_submission':
        require __DIR__ . '/student/view_submission.php';
        break;
    case 'student/transfer_request':
        require __DIR__ . '/student/transfer_request.php';
        break;
    case 'student/transfer_status':
        require __DIR__ . '/student/transfer_status.php';
        break;
    case 'student/change_password':
        require __DIR__ . '/student/change_password.php';
        break;
    case 'student/logout':
        require __DIR__ . '/student/logout.php';
        break;
    case 'student/download_submission':
        require __DIR__ . '/student/download_submission.php';
        break;
    // Lecturer routes
    case 'lecturer':
    case 'lecturer/':
        require __DIR__ . '/lecturer/index.php';
        break;
    case 'lecturer/login':
        require __DIR__ . '/lecturer/login.php';
        break;
    case 'lecturer/signup':
        require __DIR__ . '/lecturer/signup.php';
        break;
    case 'lecturer/signup_action':
        require __DIR__ . '/lecturer/signup_action.php';
        break;
    case 'lecturer/logout':
        require __DIR__ . '/lecturer/logout.php';
        break;
    case 'lecturer/mapping':
        require __DIR__ . '/lecturer/mapping.php';
        break;
    case 'lecturer/region':
        require __DIR__ . '/lecturer/region.php';
        break;
    case 'lecturer/save_mapping':
        require __DIR__ . '/lecturer/save_mapping.php';
        break;
    case 'lecturer/send_sms':
        require __DIR__ . '/lecturer/send_sms.php';
        break;
    case 'lecturer/edit_preference':
        require __DIR__ . '/lecturer/edit_preference.php';
        break;
    case 'lecturer/delete_preference':
        require __DIR__ . '/lecturer/delete_preference.php';
        break;
    case 'lecturer/export_excel':
        require __DIR__ . '/lecturer/export_excel.php';
        break;
    case 'lecturer/download_pdf':
        require __DIR__ . '/lecturer/download_pdf.php';
        break;
    case 'lecturer/download_pdf_backup':
        require __DIR__ . '/lecturer/download_pdf_backup.php';
        break;
    case 'lecturer/submit_mapping':
        require __DIR__ . '/lecturer/submit_mapping.php';
        break;
    // Admin routes
    case 'admin':
    case 'admin/':
        require __DIR__ . '/admin/index.php';
        break;
    case 'admin/login':
        require __DIR__ . '/admin/login.php';
        break;
    case 'admin/logout':
        require __DIR__ . '/admin/logout.php';
        break;
    case 'admin/approve_transfer':
        require __DIR__ . '/admin/approve_transfer.php';
        break;
    case 'admin/assign_districts':
        require __DIR__ . '/admin/assign_districts.php';
        break;
    case 'admin/assign_lecturers':
        require __DIR__ . '/admin/assign_lecturers.php';
        break;
    case 'admin/assign_students':
        require __DIR__ . '/admin/assign_students.php';
        break;
    case 'admin/manage_lecturers':
        require __DIR__ . '/admin/manage_lecturers.php';
        break;
    case 'admin/reject_transfer':
        require __DIR__ . '/admin/reject_transfer.php';
        break;
    case 'admin/send_sms':
        require __DIR__ . '/admin/send_sms.php';
        break;
    case 'admin/teaching':
        require __DIR__ . '/admin/teaching.php';
        break;
    case 'admin/transfers':
        require __DIR__ . '/admin/transfers.php';
        break;
    case 'admin/view_lecturers':
        require __DIR__ . '/admin/view_lecturers.php';
        break;
    case 'admin/view_student':
        require __DIR__ . '/admin/view_student.php';
        break;
    case 'admin/download_pdf':
        require __DIR__ . '/admin/download_pdf.php';
        break;
    case 'admin/view_pdf':
        require __DIR__ . '/admin/view_pdf.php';
        break;
    case 'admin/fetch_assigned_districts':
        require __DIR__ . '/admin/fetch_assigned_districts.php';
        break;
    case 'admin/fetch_districts':
        require __DIR__ . '/admin/fetch_districts.php';
        break;
    case 'admin/fetch_mapping':
        require __DIR__ . '/admin/fetch_mapping.php';
        break;
    case 'admin/grant_permission':
        require __DIR__ . '/admin/grant_permission.php';
        break;
    case 'admin/return_mapping':
        require __DIR__ . '/admin/return_mapping.php';
        break;
    case 'admin/sub_map':
        require __DIR__ . '/admin/sub_map.php';
        break;
    case 'admin/try':
        require __DIR__ . '/admin/try.php';
        break;
    // Help pages
    case 'help/index':
        require __DIR__ . '/help/index.php';
        break;
    case 'help/login':
        require __DIR__ . '/help/login.php';
        break;
    case 'help/registration':
        require __DIR__ . '/help/registration.php';
        break;
    default:
        http_response_code(404);
        require __DIR__ . '/errors/404.php';
        break;
}
