<?php include 'header.php'; ?>

<div class="container mt-5">
    <div class="whatsapp-contact text-center mb-4">
        <a href="https://wa.me/233274340033" target="_blank" class="btn btn-success" style="display: inline-flex; align-items: center; text-decoration: none;">
            <img src="whatsapp.png" alt="WhatsApp" style="width: 24px; height: 24px; margin-right: 8px;">
            Contact Support on WhatsApp
        </a>
    </div>

    <div class="card shadow-lg p-4">
        <h2 class="text-center mb-4">Submitting Student Details</h2>
        <p class="text-center mb-4">Welcome to the University of Education, Winneba - School of Business Internship Portal! Follow these instructions to submit your details and internship acceptance letter.</p>

        <h3>Before You Begin</h3>
        <p>Ensure you have the following ready:</p>
        <ul class="list-unstyled ms-3">
            <li>Your internship acceptance letter in PDF, JPG, or PNG format.</li>
            <li>Information about your internship organization or school.</li>
        </ul>

        <ol class="list-group list-group-numbered">
            <li class="list-group-item">
                <strong>Access the Student Details Form:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>Login:</strong> Ensure you are logged into your account.</li>
                    <li><strong>Navigate:</strong> Go to the <a href="../student/login" class="text-primary">Student Details Page</a>.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Fill in Your Personal Details:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>Surname:</strong> Enter your surname.</li>
                    <li><strong>First Name:</strong> Enter your first name.</li>
                    <li><strong>Other Names:</strong> Enter any other names (optional).</li>
                    <li><strong>Telephone Number:</strong> Provide a valid telephone number (10 digits).</li>
                    <li><strong>Email:</strong> Enter your email address.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Select Your Course of Study:</strong>
                <ul class="list-unstyled ms-3">
                    <li>Choose your course from the dropdown menu based on your internship group.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Enter Internship Details:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>Name of Organisation/School:</strong> Enter the name of your internship organization or school.</li>
                    <li><strong>Number of Months:</strong> Select the duration of your internship.</li>
                    <li><strong>Location:</strong> Provide the location of your organization or school.</li>
                    <li><strong>GPS/Google Location:</strong> Enter the GPS or Google location.</li>
                    <li><strong>Region:</strong> Select your region from the dropdown menu.</li>
                    <li><strong>District:</strong> Select your district (populated based on the selected region).</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Upload Your Acceptance Letter:</strong>
                <ul class="list-unstyled ms-3">
                    <li>Click the "Choose File" button and select your acceptance letter file.</li>
                </ul>
            </li>

            <li class="list-group-item">
                <strong>Save or Submit Your Details:</strong>
                <ul class="list-unstyled ms-3">
                    <li><strong>Save and Continue Later:</strong> Click this button if you want to save your details and complete the submission later.</li>
                    <li><strong>Submit:</strong> Click this button to submit your details for review.</li>
                </ul>
            </li>
        </ol>

        <h3>Status Messages</h3>
        <ul class="list-unstyled ms-3">
            <li>You will receive status messages on the page based on your actions:</li>
            <li><strong>Details Submitted:</strong> Your details have been successfully submitted.</li>
            <li><strong>Details Saved:</strong> Your details have been saved, and you can continue later.</li>
            <li><strong>Error Uploading File:</strong> There was an error uploading your file. Please try again.</li>
            <li><strong>Invalid File Type:</strong> Only PDF, JPG, and PNG files are allowed.</li>
        </ul>

        <h3>If You Encounter Issues</h3>
        <ul class="list-unstyled ms-3">
            <li>If your details cannot be submitted, ensure all fields are correctly filled.</li>
            <li>For further assistance, contact the help desk:</li>
            <li><strong>Email:</strong> <a href="mailto:help@uew-sob.com" class="text-primary">help@uew-sob.com</a></li>
            <li><strong>Phone:</strong>
                <div class="d-block">
                    024 365 8609 <br>
                    026 881 8765 <br>
                    024 078 1947
                </div>
            </li>
        </ul>
    </div>
</div>

<?php include 'footer.php'; ?>
