<?php
require '../vendor/setasign/fpdf/fpdf.php'; // Adjust this path if necessary

session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

// Fetch lecturer details and their mappings
$lecturerId = isset($_GET['lecturer_id']) ? intval($_GET['lecturer_id']) : 0;

// Fetch lecturer details
$stmt = $pdo->prepare('SELECT name, car_number, staff_id, department FROM lecturer_login WHERE id = ?');
$stmt->execute([$lecturerId]);
$lecturer = $stmt->fetch(PDO::FETCH_ASSOC);

if ($lecturer) {
    $lecturer = array_map(function($value) {
        return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
    }, $lecturer);
} else {
    echo "Lecturer not found.";
    exit;
}

// Fetch supervision data sorted by date
$stmt = $pdo->prepare('
    SELECT sm.date_of_supervision, sm.student_name, u.index_number, sm.from_location, sm.to_location, sm.distance, sm.nights
    FROM supervision_mapping sm
    LEFT JOIN student_details sd ON sm.student_name = CONCAT(sd.first_name, " ", sd.surname)
    LEFT JOIN users u ON sd.user_id = u.id
    WHERE sm.lecturer_id = ?
    ORDER BY sm.date_of_supervision ASC
');
$stmt->execute([$lecturerId]);
$supervisionData = $stmt->fetchAll(PDO::FETCH_ASSOC);

$supervisionData = array_map(function($row) {
    return array_map(function($value) {
        return htmlspecialchars($value, ENT_QUOTES, 'UTF-8');
    }, $row);
}, $supervisionData);

// Calculate totals
$totalDistance = 0;
$totalNights = 0;
foreach ($supervisionData as $data) {
    $totalDistance += $data['distance'];
    $totalNights += $data['nights'];
}

// Define the PDF class (same as in lecturer's section)
class PDF extends FPDF {
    function Header() {
        $this->SetFont('Arial', 'B', 12);
        $this->Cell(0, 5, 'UNIVERSITY OF EDUCATION, WINNEBA', 0, 1, 'C');
        $this->Cell(0, 5, 'SCHOOL OF BUSINESS', 0, 1, 'C');
        $this->Cell(0, 5, 'INTERNSHIP CLAIM FOR THE 2024/25 ACADEMIC YEAR', 0, 1, 'C');
        $this->Ln(5);
    }

    function LecturerDetails($lecturer) {
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 5, 'Name: ' . $lecturer['name'], 0, 1);
        $this->Cell(0, 5, 'Staff No.: ' . $lecturer['staff_id'], 0, 1);
        $this->Cell(0, 5, 'Car Reg. No.: ' . $lecturer['car_number'], 0, 1);
        $this->Cell(0, 5, 'Department: ' . $lecturer['department'], 0, 1);
        $this->Ln(5);
    }

    function SupervisionTable($header, $data, $totalDistance, $totalNights) {
        $this->SetFont('Arial', 'B', 10);
        $widths = [30, 50, 30, 40, 40, 30, 20];

        for ($i = 0; $i < count($header); $i++) {
            $this->Cell($widths[$i], 7, $header[$i], 1, 0, 'C');
        }
        $this->Ln();

        $this->SetFont('Arial', '', 10);
        foreach ($data as $row) {
            $x = $this->GetX();
            $y = $this->GetY();

            $this->MultiCell($widths[0], 6, $row['date_of_supervision'], 1, 'L');
            $this->SetXY($x + $widths[0], $y);

            $this->MultiCell($widths[1], 6, $row['student_name'], 1, 'L');
            $this->SetXY($x + array_sum(array_slice($widths, 0, 2)), $y);

            $this->MultiCell($widths[2], 6, $row['index_number'], 1, 'L');
            $this->SetXY($x + array_sum(array_slice($widths, 0, 3)), $y);

            $this->MultiCell($widths[3], 6, $row['from_location'], 1, 'L');
            $this->SetXY($x + array_sum(array_slice($widths, 0, 4)), $y);

            $this->MultiCell($widths[4], 6, $row['to_location'], 1, 'L');
            $this->SetXY($x + array_sum(array_slice($widths, 0, 5)), $y);

            $this->MultiCell($widths[5], 6, number_format($row['distance'], 2), 1, 'R');
            $this->SetXY($x + array_sum(array_slice($widths, 0, 6)), $y);

            $this->MultiCell($widths[6], 6, $row['nights'], 1, 'C');
            $this->SetXY($x, $y + 6);
        }

        $this->SetFont('Arial', 'B', 10);
        $this->Cell(array_sum(array_slice($widths, 0, 5)), 6, 'Total', 1);
        $this->Cell($widths[5], 6, number_format($totalDistance, 2), 1, 0, 'R');
        $this->Cell($widths[6], 6, $totalNights, 1, 0, 'C');
        $this->Ln(10);

        $this->Cell(0, 10, 'Signature: ........................................', 0, 1, 'L');
        $this->Cell(0, 10, 'Date: ' . date('d-M-Y'), 0, 1, 'L');
    }
}

$pdf = new PDF('L', 'mm', 'A4');
$pdf->AddPage();
$pdf->LecturerDetails($lecturer);
$pdf->SupervisionTable(['Date', 'Student', 'Index', 'From', 'To', 'Distance (KM)', 'Nights'], $supervisionData, $totalDistance, $totalNights);

// Create a filename based on the lecturer's name
$filename = str_replace(' ', '_', strtolower($lecturer['name'])) . '_mapping.pdf';
$pdf->Output('I', $filename); // 'I' for inline view in browser
?>
