<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php'; // Database connection

$successMessage = '';
$errorMessage = '';

if (isset($_SESSION['successMessage'])) {
    $successMessage = $_SESSION['successMessage'];
    unset($_SESSION['successMessage']);
}
if (isset($_SESSION['errorMessage'])) {
    $errorMessage = $_SESSION['errorMessage'];
    unset($_SESSION['errorMessage']);
}

// Handle CSV upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['upload_csv'])) {
    if (isset($_FILES['csv_file']) && $_FILES['csv_file']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['csv_file']['tmp_name'];
        $fileName = $_FILES['csv_file']['name'];
        $fileType = $_FILES['csv_file']['type'];

        $allowedTypes = ['text/csv', 'application/vnd.ms-excel'];
        if (in_array($fileType, $allowedTypes)) {
            if (($handle = fopen($fileTmpPath, 'r')) !== false) {
                fgetcsv($handle);
                $pdo->beginTransaction();
                try {
                    while (($data = fgetcsv($handle, 1000, ',')) !== false) {
                        $indexNumber = trim($data[0]);
                        if (!empty($indexNumber)) {
                            $stmt = $pdo->prepare('INSERT INTO valid_index_numbers (index_number) VALUES (:index_number)');
                            $stmt->bindParam(':index_number', $indexNumber);
                            $stmt->execute();
                        }
                    }
                    $pdo->commit();
                    fclose($handle);
                    $_SESSION['successMessage'] = 'CSV file uploaded successfully.';
                } catch (Exception $e) {
                    $pdo->rollBack();
                    $_SESSION['errorMessage'] = 'Error processing CSV file: ' . $e->getMessage();
                }
            } else {
                $_SESSION['errorMessage'] = 'Unable to open the CSV file.';
            }
        } else {
            $_SESSION['errorMessage'] = 'Please upload a valid CSV file.';
        }
    } else {
        $_SESSION['errorMessage'] = 'Please select a CSV file to upload.';
    }
    header('Location: upload_index_numbers.php');
    exit;
}

// Handle manual form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_index_number'])) {
    $indexNumber = htmlspecialchars($_POST['index_number'], ENT_QUOTES, 'UTF-8');
    if (!empty($indexNumber)) {
        try {
            $stmt = $pdo->prepare('INSERT INTO valid_index_numbers (index_number) VALUES (:index_number)');
            $stmt->bindParam(':index_number', $indexNumber);
            $stmt->execute();
            $_SESSION['successMessage'] = 'Index number added successfully.';
        } catch (Exception $e) {
            $_SESSION['errorMessage'] = 'Error: ' . $e->getMessage();
        }
    } else {
        $_SESSION['errorMessage'] = 'Index number cannot be empty.';
    }
    header('Location: upload_index_numbers.php');
    exit;
}

// Fetch distinct courses from student_details
$stmt = $pdo->prepare('SELECT DISTINCT `course` FROM student_details');
$stmt->execute();
$courses = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Index Numbers</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            color: #333;
            font-family: 'Arial', sans-serif;
        }

        .container {
            max-width: 900px;
            margin: 3rem auto;
        }

        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            transition: transform 0.3s ease;
        }

        .card:hover {
            transform: translateY(-5px);
        }

        .card-header {
            font-size: 1.25rem;
            border-bottom: none;
            background: #f8f9fa;
            text-align: center;
            padding: 1rem 0;
        }

        .btn {
            border-radius: 5px;
        }

        .btn-primary {
            background-color: #0066cc;
            border: none;
        }

        .btn-primary:hover {
            background-color: #0056b3;
        }

        .form-control {
            border: 1px solid #dee2e6;
            border-radius: 5px;
        }

        .alert {
            border-radius: 5px;
            font-size: 0.9rem;
        }

        .link-style {
            display: block;
            margin-top: 10px;
            color: #007bff;
            text-decoration: none;
            text-align: center;
        }

        .link-style:hover {
            text-decoration: underline;
        }

        h2 {
            font-weight: 600;
            text-align: center;
            margin-bottom: 2rem;
        }
    </style>
</head>
<body>
<?php include 'admin_header.php'; ?>

<div class="container">
    <h2>Manage Index Numbers & Download Acceptance Letters</h2>

    <?php if (!empty($successMessage)): ?>
        <div class="alert alert-success text-center">
            <?php echo htmlspecialchars($successMessage); ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($errorMessage)): ?>
        <div class="alert alert-danger text-center">
            <?php echo htmlspecialchars($errorMessage); ?>
        </div>
    <?php endif; ?>

    <div class="row g-4">
        <!-- CSV Upload Form -->
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Upload CSV</h4>
                <div class="card-body">
                    <form method="POST" enctype="multipart/form-data">
                        <div class="mb-3">
                            <input type="file" class="form-control" name="csv_file" id="csv_file" required>
                        </div>
                        <div class="d-grid mb-2">
                            <button type="submit" name="upload_csv" class="btn btn-primary">Upload CSV</button>
                        </div>
                        <a href="download_sample.php" class="link-style">Download Sample CSV</a>
                    </form>
                </div>
            </div>
        </div>

        <!-- Download Acceptance Letters by Course -->
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Download Acceptance Letters</h4>
                <div class="card-body">
                    <form method="POST" action="download_acceptance_letters.php">
                        <div class="mb-3">
                            <select name="course" class="form-select" required>
                                <option value="">Select Course</option>
                                <?php foreach ($courses as $course): ?>
                                    <option value="<?php echo htmlspecialchars($course['course'], ENT_QUOTES, 'UTF-8'); ?>">
                                        <?php echo htmlspecialchars($course['course'], ENT_QUOTES, 'UTF-8'); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="download_acceptance_letters" class="btn btn-info">Download Letters</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 mt-4">
        <!-- Manual Add Form -->
        <div class="col-lg-6 col-md-12">
            <div class="card p-3">
                <h4 class="card-header">Add Index Number Manually</h4>
                <div class="card-body">
                    <form method="POST">
                        <div class="mb-3">
                            <input type="text" class="form-control" name="index_number" id="index_number" placeholder="Enter index number" required>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="add_index_number" class="btn btn-success">Add Index Number</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS and Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>

</body>
</html>
