<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $lecturerId = htmlspecialchars($_POST['lecturer_id'], ENT_QUOTES, 'UTF-8');
    $region = htmlspecialchars($_POST['region'], ENT_QUOTES, 'UTF-8');
    $districts = $_POST['districts'] ?? [];

    // Convert districts array to JSON string for storage
    $districtsJson = json_encode($districts);

    // Update lecturer's district preferences
    $stmt = $pdo->prepare('
        UPDATE lecturer_preferences 
        SET preferred_districts = ? 
        WHERE lecturer_id = ? AND preferred_region = ?
    ');
    $stmt->execute([$districtsJson, $lecturerId, $region]);

    $_SESSION['statusMessage'] = 'Districts assigned successfully.';
    header('Location: assign_dist.php');
    exit;
}
?>
