<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

// Fetch all submitted results entered by lecturers from the student_results table
$query = "
    SELECT 
        sd.first_name,
        sd.surname,
        u.index_number,
        sr.marks,
        sr.grade,
        sr.gp,
        sr.description,
        l.name AS lecturer_name
    FROM student_results sr
    JOIN student_details sd ON sr.student_id = sd.id
    JOIN users u ON sd.user_id = u.id
    JOIN lecturer_login l ON sd.lecturer_id = l.id
    WHERE sr.status = 'submitted'  -- Only fetch results that are submitted
";
$stmt = $pdo->prepare($query);
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>View Results</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<?php include 'admin_header.php'; ?>

<div class="container mt-4">
    <h2>All Results</h2>
    <a href="download_results.php" class="btn btn-success mb-3">Download Results as Excel</a>
    <?php if (empty($results)): ?>
        <div class="alert alert-warning">No submitted results found.</div>
    <?php else: ?>
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Index Number</th>
                    <th>Student Name</th>
                    <th>Lecturer Name</th>
                    <th>Marks</th>
                    <th>Grade</th>
                    <th>GP</th>
                    <th>Description</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($results as $result): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($result['index_number']); ?></td>
                        <td><?php echo htmlspecialchars($result['first_name'] . ' ' . $result['surname']); ?></td>
                        <td><?php echo htmlspecialchars($result['lecturer_name']); ?></td>
                        <td><?php echo htmlspecialchars($result['marks']); ?></td>
                        <td><?php echo htmlspecialchars($result['grade']); ?></td>
                        <td><?php echo htmlspecialchars($result['gp']); ?></td>
                        <td><?php echo htmlspecialchars($result['description']); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.10.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
