<?php
include '../config/database.php';

// Check if the region is set
if (isset($_GET['region'])) {
    $region = htmlspecialchars($_GET['region'], ENT_QUOTES, 'UTF-8');

    // Fetch districts based on the selected region
    $query = 'SELECT DISTINCT district FROM student_details WHERE region = :region AND district IS NOT NULL AND district != ""';
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':region', $region);
    $stmt->execute();
    $districts = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return the districts as a JSON array
    echo json_encode(array_column($districts, 'district'));
}
?>
