<?php
// Include the database connection
include '../config/database.php';

// Get the region and student group from the AJAX request
$region = $_GET['region'] ?? '';
$student_group = $_GET['student_group'] ?? '';

// Map region initials back to full region names
$regionInitials = [
    'CR' => 'Central Region',
    'GAR' => 'Greater Accra Region',
    'WN' => 'Western North',
    'UWR' => 'Upper West Region',
    'ASH' => 'Ashanti Region',
    'BER' => 'Bono East Region',
    'BR' => 'Bono',
    'ER' => 'Eastern Region',
    'NR' => 'Northern Region',
    'OR' => 'Oti Region',
    'SR' => 'Savannah Region',
    'UER' => 'Upper East Region',
    'VR' => 'Volta Region',
    'AR' => 'Ahafo Region',
    'WR' => 'Western Region',
    'NE' => 'North East'
];

// Get the full region name from the initials
$fullRegion = $regionInitials[$region] ?? '';

// Prepare the SQL query
$sql = 'SELECT sd.first_name, sd.surname, sd.district 
        FROM student_details sd
        JOIN users u ON sd.user_id = u.id
        WHERE sd.region = :region AND sd.status = "submitted"';

// Add the student group filter if specified
if ($student_group && $student_group != 'all') {
    $sql .= ' AND u.group = :student_group';
}

// Prepare and execute the query
$stmt = $pdo->prepare($sql);
$params = ['region' => $fullRegion];
if ($student_group && $student_group != 'all') {
    $params['student_group'] = $student_group;
}
$stmt->execute($params);
$students = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Return data as JSON
header('Content-Type: application/json');
echo json_encode($students);
?>
