<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

// Get the region from the GET request
$region = isset($_GET['region']) ? $_GET['region'] : '';

if ($region) {
    try {
        // Fetch lecturers who have the selected region as a preference
        $stmt = $pdo->prepare('
            SELECT ll.id, ll.name, ll.department,
                   GROUP_CONCAT(lp.preferred_region) AS preferred_regions,
                   (SELECT GROUP_CONCAT(lad.district ORDER BY lad.district SEPARATOR ", ") 
                    FROM lecturer_assigned_districts lad 
                    WHERE lad.lecturer_id = ll.id AND lad.region = lp.preferred_region) AS assigned_districts
            FROM lecturer_login ll
            JOIN lecturer_preferences lp ON ll.id = lp.lecturer_id
            WHERE FIND_IN_SET(?, lp.preferred_region)
            GROUP BY ll.id
        ');
        $stmt->execute([$region]);
        $lecturers = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Prepare the data for JSON response
        $response = [];
        foreach ($lecturers as $lecturer) {
            $assignedDistricts = $lecturer['assigned_districts'] ? explode(', ', $lecturer['assigned_districts']) : [];
            
            // Fetch available districts for the region, excluding assigned ones
            $stmt2 = $pdo->prepare('SELECT district FROM districts WHERE region = ? AND district NOT IN (' . implode(',', array_fill(0, count($assignedDistricts), '?')) . ')');
            $params = array_merge([$region], $assignedDistricts);
            $stmt2->execute($params);
            $availableDistricts = $stmt2->fetchAll(PDO::FETCH_COLUMN);

            $response[] = [
                'id' => $lecturer['id'],
                'name' => $lecturer['name'],
                'department' => $lecturer['department'],
                'preferred_regions' => explode(',', $lecturer['preferred_regions']),
                'assigned_districts' => $assignedDistricts,
                'available_districts' => $availableDistricts,
            ];
        }

        echo json_encode($response);
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'An error occurred while fetching data.']);
    }
} else {
    http_response_code(400);
    echo json_encode(['error' => 'Invalid region specified.']);
}
?>
