<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php'; // Database connection

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['download_acceptance_letters'])) {
    $course = htmlspecialchars($_POST['course'], ENT_QUOTES, 'UTF-8');

    // Fetch acceptance letters of users with 'submitted' status and corresponding index number from users table
    $stmt = $pdo->prepare('
        SELECT sd.acceptance_letter, u.index_number
        FROM student_details sd
        JOIN users u ON sd.user_id = u.id
        WHERE sd.course = :course AND sd.status = "submitted" AND sd.acceptance_letter IS NOT NULL
    ');
    $stmt->bindParam(':course', $course);
    $stmt->execute();
    $letters = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($letters)) {
        $zip = new ZipArchive();
        $zipFileName = 'acceptance_letters_' . $course . '.zip';

        if ($zip->open($zipFileName, ZipArchive::CREATE) === TRUE) {
            foreach ($letters as $letter) {
                $filePath = '../uploads/' . $letter['acceptance_letter'];
                if (file_exists($filePath)) {
                    $zip->addFile($filePath, $letter['index_number'] . '_' . basename($filePath));
                }
            }
            $zip->close();

            header('Content-Type: application/zip');
            header('Content-Disposition: attachment; filename=' . $zipFileName);
            header('Content-Length: ' . filesize($zipFileName));

            readfile($zipFileName);
            unlink($zipFileName); // Delete the zip file after download
            exit;
        } else {
            $_SESSION['errorMessage'] = 'Failed to create ZIP file.';
        }
    } else {
        $_SESSION['errorMessage'] = 'No acceptance letters found for the selected course.';
    }

    header('Location: upload_index_numbers.php');
    exit;
}
