<?php
session_start();
include '../config/database.php'; // Database connection

// Fetch all student details
$query = 'SELECT * FROM student_details';
if (isset($_GET['filter']) && in_array($_GET['filter'], ['submitted', 'saved'])) {
    $filter = $_GET['filter'];
    $query .= ' WHERE status = :status';
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':status', $filter, PDO::PARAM_STR);
    $stmt->execute();
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
} else {
    $stmt = $pdo->query($query);
    $students = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Handle delete action
if (isset($_GET['delete_id'])) {
    $deleteId = $_GET['delete_id'];
    $stmt = $pdo->prepare('DELETE FROM student_details WHERE id = :id');
    $stmt->bindParam(':id', $deleteId, PDO::PARAM_INT);
    $stmt->execute();
    header("Location: manage_students.php");
    exit;
}

// Handle update action
if (isset($_POST['update_student'])) {
    $id = $_POST['id'];
    $surname = $_POST['surname'];
    $first_name = $_POST['first_name'];
    $other_names = $_POST['other_names'];
    $email = $_POST['email'];
    $telephone = $_POST['telephone'];

    $stmt = $pdo->prepare('UPDATE student_details SET surname = :surname, first_name = :first_name, other_names = :other_names, email = :email, telephone = :telephone WHERE id = :id');
    $stmt->bindParam(':surname', $surname);
    $stmt->bindParam(':first_name', $first_name);
    $stmt->bindParam(':other_names', $other_names);
    $stmt->bindParam(':email', $email);
    $stmt->bindParam(':telephone', $telephone);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    header("Location: manage_students.php");
    exit;
}

// Handle file upload for "saved" statuses
if (isset($_POST['upload_letter'])) {
    $id = $_POST['id'];
    $fileTmpPath = $_FILES['acceptance_letter']['tmp_name'];
    $fileName = $_FILES['acceptance_letter']['name'];
    $uploadDir = '../uploads/';
    $dest_path = $uploadDir . $fileName;

    if (move_uploaded_file($fileTmpPath, $dest_path)) {
        $stmt = $pdo->prepare('UPDATE student_details SET acceptance_letter = :letter, status = "submitted" WHERE id = :id');
        $stmt->bindParam(':letter', $fileName);
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $_SESSION['success'] = "Letter uploaded and status updated!";
    } else {
        $_SESSION['error'] = "Error uploading file!";
    }
    header("Location: manage_students.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Students - Internship Portal</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f9f9f9;
        }

        .table-container {
            box-shadow: 0px 0px 20px rgba(0, 0, 0, 0.05);
            border-radius: 8px;
            overflow: hidden;
        }

        .search-bar, .filter-dropdown {
            margin-right: 1rem;
        }

        .action-icons i {
            cursor: pointer;
            font-size: 18px;
            margin: 0 5px;
        }

        .alert {
            border-radius: 5px;
            margin: 1rem 0;
        }

        .table {
            border-collapse: separate;
            border-spacing: 0 15px;
        }

        .table thead {
            background-color: #007bff;
            color: #fff;
        }

        .table td {
            vertical-align: middle;
        }

        .search-filter-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1rem;
        }

        .fa-edit:hover, .fa-trash-alt:hover, .fa-upload:hover {
            color: #0056b3;
        }
    </style>
</head>
<body>
<?php include 'admin_header.php'; ?>

<div class="container mt-4">
    <h2 class="text-center mb-4">Student Broad Sheet</h2>
    
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <div class="search-filter-container">
        <form method="GET" class="d-flex">
            <input type="text" name="search" class="form-control search-bar" placeholder="Search by name, email, or course">
            <select name="filter" class="form-select filter-dropdown">
                <option value="">All Statuses</option>
                <option value="submitted" <?php if (isset($filter) && $filter == 'submitted') echo 'selected'; ?>>Submitted</option>
                <option value="saved" <?php if (isset($filter) && $filter == 'saved') echo 'selected'; ?>>Saved</option>
            </select>
            <button type="submit" class="btn btn-primary">Search</button>
        </form>
    </div>

    <div class="table-container">
        <table class="table table-hover table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Surname</th>
                    <th>First Name</th>
                    <th>Email</th>
                    <th>Telephone</th>
                    <th>Course</th>
                    <th>Status</th>
                    <th>Letter</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach ($students as $student): ?>
                <tr>
                    <td><?php echo $student['id']; ?></td>
                    <td><?php echo $student['surname']; ?></td>
                    <td><?php echo $student['first_name']; ?></td>
                    <td><?php echo $student['email']; ?></td>
                    <td><?php echo $student['telephone']; ?></td>
                    <td><?php echo $student['course']; ?></td>
                    <td><?php echo $student['status']; ?></td>
                    <td>
                        <?php if ($student['acceptance_letter']): ?>
                            <a href="../uploads/<?php echo $student['acceptance_letter']; ?>" target="_blank">View</a>
                        <?php else: ?>
                            N/A
                        <?php endif; ?>
                    </td>
                    <td class="action-icons">
                        <form style="display:inline-block" method="POST">
                            <input type="hidden" name="id" value="<?php echo $student['id']; ?>">
                            <i class="fas fa-edit text-primary" title="Edit" onclick="this.closest('form').submit();"></i>
                        </form>
                        <a href="?delete_id=<?php echo $student['id']; ?>" onclick="return confirm('Are you sure?')">
                            <i class="fas fa-trash-alt text-danger" title="Delete"></i>
                        </a>
                        <?php if ($student['status'] == 'saved'): ?>
                            <form style="display:inline-block" method="POST" enctype="multipart/form-data">
                                <input type="hidden" name="id" value="<?php echo $student['id']; ?>">
                                <label for="file-<?php echo $student['id']; ?>" class="upload-icon">
                                    <i class="fas fa-upload text-warning" title="Upload Letter"></i>
                                </label>
                                <input type="file" name="acceptance_letter" id="file-<?php echo $student['id']; ?>" style="display:none;" onchange="this.closest('form').submit();">
                            </form>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

</body>
</html>
