<?php
include '../config/database.php';

$response = ['success' => false, 'message' => '', 'dbBackupPath' => '', 'fileBackupPath' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $action = $data['action'];

    if ($action === 'backup') {
        // Backup database and files
        try {
            // Check if backups directory exists
            if (!file_exists('../backups')) {
                mkdir('../backups', 0777, true);
            }

            // Database backup
            $backupFileName = 'database_backup_' . date('Ymd_His') . '.sql';
            $backupFilePath = '../backups/' . $backupFileName;

            $dbBackupCommand = "mysqldump --user=" . DB_USER . " --password=" . DB_PASS . " --host=" . DB_HOST . " " . DB_NAME . " > " . escapeshellarg($backupFilePath);
            
            // Execute the backup command and capture output
            exec($dbBackupCommand . ' 2>&1', $output, $return_var);
            
            if ($return_var !== 0) {
                throw new Exception("Database backup failed: " . implode("\n", $output));
            }

            // Zip the uploads directory
            $zip = new ZipArchive();
            $zipFileName = '../backups/uploads_backup_' . date('Ymd_His') . '.zip';
            if ($zip->open($zipFileName, ZipArchive::CREATE) === TRUE) {
                $directoriesToBackup = ['../uploads', '../documents', '../profile_pictures'];
                foreach ($directoriesToBackup as $dir) {
                    $files = glob($dir . '/*');
                    foreach ($files as $file) {
                        if (is_file($file)) {
                            $zip->addFile($file, basename($file)); // Add file to zip
                        }
                    }
                }
                $zip->close();
            } else {
                throw new Exception("Error creating zip file.");
            }

            // If successful, return the paths for download
            $response['success'] = true;
            $response['dbBackupPath'] = $backupFilePath;
            $response['fileBackupPath'] = $zipFileName;
        } catch (Exception $e) {
            $response['message'] = 'Backup failed: ' . $e->getMessage();
        }
    } elseif ($action === 'reset') {
        // Reset the system
        try {
            $pdo->beginTransaction();
            $tablesToTruncate = ['users', 'student_details', 'lecturer_login', 'transfer_requests', 'password_resets'];

            foreach ($tablesToTruncate as $table) {
                $pdo->exec("TRUNCATE TABLE $table");
            }

            // Remove files from directories
            $directories = ['../uploads', '../documents', '../profile_pictures'];
            foreach ($directories as $dir) {
                $files = glob($dir . '/*');
                foreach ($files as $file) {
                    if (is_file($file)) {
                        unlink($file);
                    }
                }
            }

            $pdo->commit();
            $response['success'] = true;
        } catch (Exception $e) {
            $pdo->rollBack();
            $response['message'] = 'Reset failed: ' . $e->getMessage();
        }
    }
}

echo json_encode($response);
