<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Fetch admin details if logged in
$admin_id = '';
if (isset($_SESSION['admin_id'])) {
    include '../config/database.php';
    $admin_id = $_SESSION['admin_id'];
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="admin_style.css" rel="stylesheet">
</head>

<body>
    <!-- Wrapper -->
    <div class="d-flex" id="wrapper">
<!-- Sidebar -->
<div class="border-end" id="sidebar-wrapper">
    <div class="sidebar-heading text-center py-4">SOB-IMS</div>
    <div class="list-group list-group-flush">
        <!-- Home Link -->
        <a href="index" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-home"></i> Home</a>
        <!-- Students Link -->
        <a href="students" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-users"></i> Students</a>
        <!-- Lecturers Link -->
        <a href="lecturers" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-chalkboard-teacher"></i> Lecturers</a>
        
        <a href="assign_region" class="list-group-item list-group-item-action bg-light text-dark ms-3"><i class="fas fa-map-marked-alt"></i> Assign Region</a>
        <!-- Assign Districts under Lecturers -->
        <a href="assign_dist" class="list-group-item list-group-item-action bg-light text-dark ms-3"><i class="fas fa-map-marked-alt"></i> Assign Districts</a>
        <!-- Mapping under Lecturers -->
        <a href="fetch_mapping" class="list-group-item list-group-item-action bg-light text-dark ms-3"><i class="fas fa-map-marker-alt"></i> Mapping</a>
        <!-- Transfers Link -->
        <a href="transfers" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-exchange-alt"></i> Transfers</a>
        <!-- Results for Admin to View -->
        <a href="results" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-chart-bar"></i> Results</a>
        <!-- Assign Students Link -->
        <a href="assign_students" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-user-plus"></i> Assign Students</a>
		<a href="match" class="list-group-item list-group-item-action bg-light text-dark"><i class="fas fa-tasks"></i> Assignment Status</a>

        
    </div>
</div>

        <!-- /#sidebar-wrapper -->

        <!-- Page Content -->
        <div id="page-content-wrapper">
            <!-- Top Navigation -->
            <nav class="navbar navbar-expand-lg navbar-light bg-light border-bottom">
                <div class="container-fluid">
                    <a class="navbar-brand" href="#">Admin Panel</a>
                    <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="collapse navbar-collapse" id="navbarSupportedContent">
                        <ul class="navbar-nav ms-auto mt-2 mt-lg-0">
                            <li class="nav-item active">
                                <a class="nav-link" href="#">Home</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="staff">Staff</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" href="upload_index_numbers">Settings</a>
                            </li>
                            <li class="nav-item">
                                <a class="btn btn-outline-danger ms-2" href="logout">Logout</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </nav>
            <!-- End of Top Navigation -->
            <!-- Main Content Container -->
            <div class="container-fluid">
