<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['admin_id'])) {
    header('Location: login');
    exit;
}
include 'admin_header.php';
include '../config/database.php';

// Fetch all transfer requests
$stmt = $pdo->prepare('
    SELECT tr.*, u.index_number, sd.first_name, sd.surname, sd.organisation_name AS current_organisation
    FROM transfer_requests tr 
    JOIN users u ON tr.user_id = u.id 
    JOIN student_details sd ON tr.user_id = sd.user_id
');
$stmt->execute();
$transfers = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container mt-4">
    <h2>Transfer Requests</h2>
    <?php if (isset($_SESSION['statusMessage'])): ?>
        <div class="alert alert-info">
            <?php 
            echo htmlspecialchars($_SESSION['statusMessage'], ENT_QUOTES, 'UTF-8'); 
            unset($_SESSION['statusMessage']);
            ?>
        </div>
    <?php endif; ?>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Name</th>
                <th>Current Organisation</th>
                <th>New Organisation</th>
                <th>Reason</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($transfers as $transfer): ?>
                <tr id="transfer-<?php echo htmlspecialchars($transfer['id'], ENT_QUOTES, 'UTF-8'); ?>">
                    <td><?php echo htmlspecialchars($transfer['first_name'] . ' ' . $transfer['surname'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($transfer['current_organisation'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($transfer['new_organisation_name'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td><?php echo htmlspecialchars($transfer['reason'], ENT_QUOTES, 'UTF-8'); ?></td>
                    <td id="status-<?php echo htmlspecialchars($transfer['id'], ENT_QUOTES, 'UTF-8'); ?>">
                        <?php if ($transfer['status'] === 'rejected'): ?>
                            <span class="badge bg-danger">Rejected</span>
                        <?php elseif ($transfer['status'] === 'approved'): ?>
                            <span class="badge bg-success">Approved</span>
                        <?php else: ?>
                            <span class="badge bg-warning">Pending</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <?php if ($transfer['status'] === 'pending'): ?>
                            <i class="fas fa-check text-success me-2" data-id="<?php echo htmlspecialchars($transfer['id'], ENT_QUOTES, 'UTF-8'); ?>" onclick="approveTransfer(this)"></i>
                            <i class="fas fa-times text-danger" data-id="<?php echo htmlspecialchars($transfer['id'], ENT_QUOTES, 'UTF-8'); ?>" onclick="rejectTransfer(this)"></i>
                        <?php else: ?>
                            <span class="text-muted"><i class="fas fa-ban"></i></span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<!-- Approve Modal -->
<div class="modal fade" id="approveModal" tabindex="-1" aria-labelledby="approveModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="approve_transfer.php" id="approve-form">
                <div class="modal-header">
                    <h5 class="modal-title" id="approveModalLabel">Approve Transfer</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to approve this transfer request?
                    <input type="hidden" name="id" id="approve-transfer-id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Approve</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reject Modal -->
<div class="modal fade" id="rejectModal" tabindex="-1" aria-labelledby="rejectModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="reject_transfer.php" id="reject-form">
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectModalLabel">Reject Transfer</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to reject this transfer request?
                    <input type="hidden" name="id" id="reject-transfer-id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Reject</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        var approveModal = document.getElementById('approveModal');
        approveModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var id = button.getAttribute('data-id');
            var modalInput = approveModal.querySelector('#approve-transfer-id');
            modalInput.value = id;
        });

        var rejectModal = document.getElementById('rejectModal');
        rejectModal.addEventListener('show.bs.modal', function (event) {
            var button = event.relatedTarget;
            var id = button.getAttribute('data-id');
            var modalInput = rejectModal.querySelector('#reject-transfer-id');
            modalInput.value = id;
        });
    });

    function approveTransfer(element) {
        var id = element.getAttribute('data-id');
        if (confirm('Are you sure you want to approve this transfer request?')) {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'approve_transfer.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    document.getElementById('status-' + id).innerHTML = '<span class="badge bg-success">Approved</span>';
                }
            };
            xhr.send('id=' + encodeURIComponent(id));
        }
    }

    function rejectTransfer(element) {
        var id = element.getAttribute('data-id');
        if (confirm('Are you sure you want to reject this transfer request?')) {
            var xhr = new XMLHttpRequest();
            xhr.open('POST', 'reject_transfer.php', true);
            xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            xhr.onreadystatechange = function () {
                if (xhr.readyState == 4 && xhr.status == 200) {
                    document.getElementById('status-' + id).innerHTML = '<span class="badge bg-danger">Rejected</span>';
                }
            };
            xhr.send('id=' + encodeURIComponent(id));
        }
    }
</script>

<?php include 'admin_footer.php'; ?>
