<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include 'admin_header.php'; // Ensure you have an admin_header.php for the admin layout
include '../config/database.php';

// Fetch all submitted mappings grouped by lecturer
$stmt = $pdo->prepare('
    SELECT l.id AS lecturer_id, l.name AS lecturer_name, l.mapping_timestamp
    FROM lecturer_login l
    WHERE l.mapping_submitted = 1
');
$stmt->execute();
$lecturers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch all permissions
$stmt = $pdo->prepare('SELECT lecturer_id FROM lecturer_permissions');
$stmt->execute();
$permissions = $stmt->fetchAll(PDO::FETCH_COLUMN, 0);
?>

<div class="container mt-4">
    <div class="row">
        <div class="col-md-3">
            <h4>Submitted Mappings</h4>
            <div class="list-group">
                <?php foreach ($lecturers as $lecturer): ?>
                    <div class="d-flex justify-content-between align-items-center list-group-item list-group-item-action">
                        <div onclick="loadPdf('<?php echo $lecturer['lecturer_id']; ?>')" style="cursor:pointer;">
                            <?php echo htmlspecialchars($lecturer['lecturer_name']); ?>
                            <br><small>Submitted on: <?php echo htmlspecialchars($lecturer['mapping_timestamp']); ?></small>
                        </div>
                        <?php if (in_array($lecturer['lecturer_id'], $permissions)): ?>
                            <form method="POST" action="return_mapping.php" style="display: inline;">
                                <input type="hidden" name="lecturer_id" value="<?php echo $lecturer['lecturer_id']; ?>">
                                <button type="submit" class="btn btn-outline-warning btn-sm">
                                    <i class="fas fa-undo-alt"></i>
                                </button>
                            </form>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="col-md-9">
            <h4>Mapping PDF Viewer</h4>
            <iframe id="pdfFrame" src="" width="100%" height="600px"></iframe>
        </div>
    </div>
</div>

<script>
function loadPdf(lecturerId) {
    const sessionId = '<?php echo session_id(); ?>';
    const fileUrl = 'view_pdf.php?lecturer_id=' + encodeURIComponent(lecturerId) + '&PHPSESSID=' + sessionId;
    document.getElementById('pdfFrame').src = fileUrl;
}
</script>

<?php include 'admin_footer.php'; // Ensure you have an admin_footer.php for the admin layout ?>
