<?php
// Ensure the required parameters are set
if (isset($_GET['phone']) && isset($_GET['message'])) {
    // Sanitize the input parameters
    $phone = htmlspecialchars($_GET['phone'], ENT_QUOTES, 'UTF-8');
    $message = htmlspecialchars($_GET['message'], ENT_QUOTES, 'UTF-8');
    
    // API credentials and parameters
    $apiKey = 'igaYAqbJLFh1JGSBOrGeYQBUa'; // Your API key
    $senderId = 'SoB-UEW'; // Your sender ID

    // Prepare the URL for sending SMS
    $apiUrl = 'https://apps.mnotify.net/smsapi?key=' . urlencode($apiKey) . '&to=' . urlencode($phone) . '&msg=' . urlencode($message) . '&sender_id=' . urlencode($senderId);

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Execute the request
    $response = curl_exec($ch);

    // Check for errors
    if ($response === false) {
        echo 'error';
    } else {
        // Decode the response
        $responseData = json_decode($response, true);

        // Check for errors based on response codes
        if (isset($responseData['status'])) {
            switch ($responseData['status']) {
                case 1000:
                    echo 'success';
                    break;
                case 1002:
                    echo 'SMS sending failed';
                    break;
                case 1003:
                    echo 'insufficient balance';
                    break;
                case 1004:
                    echo 'invalid API key';
                    break;
                case 1005:
                    echo 'invalid Phone Number';
                    break;
                case 1006:
                    echo 'invalid Sender ID';
                    break;
                case 1007:
                    echo 'Message scheduled for later delivery';
                    break;
                case 1008:
                    echo 'Empty Message';
                    break;
                case 1009:
                    echo 'Empty from date and to date';
                    break;
                case 1010:
                    echo 'No messages sent on the specified dates';
                    break;
                case 1011:
                    echo 'Numeric Sender IDs are not allowed';
                    break;
                case 1012:
                    echo 'Sender ID is not registered';
                    break;
                default:
                    echo 'Unknown error';
            }
        } else {
            echo 'error';
        }
    }

    // Close cURL
    curl_close($ch);
} else {
    echo 'error';
}
