<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

include '../config/database.php';

if (isset($_POST['lecturer_id'])) {
    $lecturerId = htmlspecialchars($_POST['lecturer_id'], ENT_QUOTES, 'UTF-8');

    // Fetch the timestamp to identify the file
    $stmt = $pdo->prepare('SELECT mapping_timestamp FROM lecturer_login WHERE id = ?');
    $stmt->execute([$lecturerId]);
    $mappingTimestamp = $stmt->fetchColumn();

    // Construct the filename
    $filename = '../admin/mapping/' . htmlspecialchars($lecturerId, ENT_QUOTES, 'UTF-8') . '_mapping_' . date('Ymd_His', strtotime($mappingTimestamp)) . '.pdf';

    // Delete the file if it exists
    if (file_exists($filename)) {
        unlink($filename);
    }

    // Reset the mapping_submitted and mapping_timestamp fields
    $stmt = $pdo->prepare('UPDATE lecturer_login SET mapping_submitted = 0, mapping_timestamp = NULL WHERE id = ?');
    $stmt->execute([$lecturerId]);

    // Optionally, add logic to notify the lecturer that their mapping was returned

    header('Location: sub_map.php');
    exit;
}
?>
