<?php

include '../includes/header.php';
include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize the username input
    $username = htmlspecialchars($_POST['username'], ENT_QUOTES, 'UTF-8');
    // Hash the password
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    // Prepare and execute the SQL statement
    $stmt = $pdo->prepare('INSERT INTO admins (username, password) VALUES (?, ?)');
    $stmt->execute([$username, $password]);

    $success = 'New admin added successfully';
}
?>

<div class="container mt-4">
    <h2>Add New Admin</h2>
    <?php if (isset($success)): ?>
        <div class="alert alert-success">
            <?php echo htmlspecialchars($success, ENT_QUOTES, 'UTF-8'); ?>
        </div>
    <?php endif; ?>
    <form method="POST" action="insert_admin.php">
        <div class="mb-3">
            <label for="username" class="form-label">Username</label>
            <input type="text" class="form-control" id="username" name="username" required>
        </div>
        <div class="mb-3">
            <label for="password" class="form-label">Password</label>
            <input type="password" class="form-control" id="password" name="password" required>
        </div>
        <button type="submit" class="btn btn-primary">Add Admin</button>
    </form>
</div>

<?php include '../../includes/footer.php'; ?>
