<?php
session_start();
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

if (!isset($_GET['file'])) {
    die("File parameter missing");
}

// Sanitize the file input
$file = basename(htmlspecialchars($_GET['file'], ENT_QUOTES, 'UTF-8'));

// Construct the full file path
$filepath = '../admin/mapping/' . $file;

// Check if the file exists and is within the allowed directory
if (file_exists($filepath) && realpath($filepath) === $filepath) {
    header('Content-Description: File Transfer');
    header('Content-Type: application/pdf');
    header('Content-Disposition: attachment; filename="' . htmlspecialchars(basename($file), ENT_QUOTES, 'UTF-8') . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($filepath));
    readfile($filepath);
    exit;
} else {
    die("File not found");
}
?>
