<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    include '../config/database.php';

    // Sanitize input data
    $lecturerId = htmlspecialchars($_POST['lecturer_id'], ENT_QUOTES, 'UTF-8');
    $selectedDistricts = array_map(function($district) {
        return htmlspecialchars($district, ENT_QUOTES, 'UTF-8');
    }, $_POST['selected_districts']);
    $region = htmlspecialchars($_POST['region'], ENT_QUOTES, 'UTF-8'); // Ensure this value is sanitized

    try {
        $pdo->beginTransaction();

        // Insert new districts
        $stmt = $pdo->prepare('INSERT INTO lecturer_assigned_districts (lecturer_id, district, region) VALUES (?, ?, ?)');
        foreach ($selectedDistricts as $district) {
            // Check if the district already exists for this lecturer and region
            $checkStmt = $pdo->prepare('SELECT COUNT(*) FROM lecturer_assigned_districts WHERE lecturer_id = ? AND district = ? AND region = ?');
            $checkStmt->execute([$lecturerId, $district, $region]);
            if ($checkStmt->fetchColumn() == 0) {
                $stmt->execute([$lecturerId, $district, $region]);
            }
        }

        $pdo->commit();
        header('Location: manage_lecturers.php');
        exit;
    } catch (PDOException $e) {
        $pdo->rollBack();
        echo 'Error: ' . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8');
    }
}
