<?php
$isLoggedIn = isset($_SESSION['user_id']);
$role = isset($_SESSION['role']) ? htmlspecialchars($_SESSION['role'], ENT_QUOTES, 'UTF-8') : 'student';
$indexNumber = isset($_SESSION['index_number']) ? htmlspecialchars($_SESSION['index_number'], ENT_QUOTES, 'UTF-8') : '';

$messages = [];
if ($isLoggedIn) {
    include '../config/database.php';
    $stmt = $pdo->prepare('SELECT messages.id, messages.subject, messages.message, messages.is_read, messages.created_at, lecturer_login.name 
                          FROM messages 
                          JOIN lecturer_login ON messages.sender_id = lecturer_login.id 
                          WHERE messages.user_id = ? 
                          ORDER BY messages.created_at DESC');
    $stmt->execute([$_SESSION['user_id']]);
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>

<nav class="navbar navbar-expand-lg navbar-light" style="background-color: #163485;">
    <div class="container-fluid">
        <a class="navbar-brand" href="../student/index">
            <img src="<?php echo htmlspecialchars('../public/img/sob_logo.png', ENT_QUOTES, 'UTF-8'); ?>" alt="Logo" width="30" height="30" class="d-inline-block align-top">
            <span class="brand-text d-none d-lg-inline" style="color: white;">UEW School of Business Internship</span>
            <span class="brand-text d-lg-none" style="color: white;">UEW SOB-Intern</span>
        </a>

        <!-- Notifications Icon for Mobile -->
        <?php if ($isLoggedIn): ?>
            <div class="d-lg-none">
                <a class="nav-link" href="#" id="notificationsDropdownMobile" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                    <i class="fas fa-bell"></i>
                    <?php $unreadCount = count(array_filter($messages, fn($msg) => !$msg['is_read'])); ?>
                    <?php if ($unreadCount > 0): ?>
                        <span class="badge bg-danger"><?php echo $unreadCount; ?></span>
                    <?php endif; ?>
                </a>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="notificationsDropdownMobile" style="max-height: 300px; overflow-y: auto;">
                    <?php if (empty($messages)): ?>
                        <li><a class="dropdown-item" href="#">No new notifications</a></li>
                    <?php else: ?>
                        <?php foreach ($messages as $message): ?>
                            <li>
                                <a class="dropdown-item <?php echo $message['is_read'] ? '' : 'fw-bold'; ?>" href="#" data-bs-toggle="modal" data-bs-target="#messageModal<?php echo $message['id']; ?>" data-id="<?php echo $message['id']; ?>">
                                    <?php echo htmlspecialchars($message['name']); ?>: <?php echo htmlspecialchars($message['subject']); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </ul>
            </div>
        <?php endif; ?>

        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <?php if ($isLoggedIn): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard" style="color: white;">
                            <i class="fas fa-tachometer-alt"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="view_submission" style="color: white;">
                            <i class="fas fa-file-alt"></i> View Submission
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="transferDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                            <i class="fas fa-exchange-alt"></i> Transfer
                        </a>
                        <ul class="dropdown-menu" aria-labelledby="transferDropdown">
                            <?php if ($role === 'student'): ?>
                                <li><a class="dropdown-item" href="transfer_request">Request Transfer</a></li>
                                <li><a class="dropdown-item" href="transfer_status">Transfer Status</a></li>
                            <?php endif; ?>
                            <?php if ($role === 'coordinator'): ?>
                                <li><a class="dropdown-item" href="transfer_approvals">Approvals</a></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php if ($role === 'coordinator'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="coordinator_dashboard" style="color: white;">
                                <i class="fas fa-chalkboard-teacher"></i> Coordinator Dashboard
                            </a>
                        </li>
                    <?php endif; ?>

                    <!-- Notifications Button for Larger Screens -->
                    <li class="nav-item dropdown d-none d-lg-block">
                        <a class="nav-link dropdown-toggle" href="#" id="notificationsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                            <i class="fas fa-bell"></i> 
                            <?php if ($unreadCount > 0): ?>
                                <span class="badge bg-danger"><?php echo $unreadCount; ?></span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="notificationsDropdown" style="max-height: 300px; overflow-y: auto;">
                            <?php if (empty($messages)): ?>
                                <li><a class="dropdown-item" href="#">No new notifications</a></li>
                            <?php else: ?>
                                <?php foreach ($messages as $message): ?>
                                    <li>
                                        <a class="dropdown-item <?php echo $message['is_read'] ? '' : 'fw-bold'; ?>" href="#" data-bs-toggle="modal" data-bs-target="#messageModal<?php echo $message['id']; ?>" data-id="<?php echo $message['id']; ?>">
                                            <?php echo htmlspecialchars($message['name']); ?>: <?php echo htmlspecialchars($message['subject']); ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                    </li>

                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                            <i class="fas fa-user"></i> <?php echo $indexNumber; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                            <li><a class="dropdown-item" href="change_password"><i class="fas fa-key"></i> Change Password</a></li>
                            <li><a class="dropdown-item" href="logout"><i class="fas fa-sign-out-alt"></i> Logout</a></li>
                        </ul>
                    </li>
                <?php else: ?>
                    <li class="nav-item d-none d-lg-block">
                        <form class="d-flex" method="POST" action="login_action">
                            <input class="form-control me-2" type="text" placeholder="Index Number" name="indexNumber" required>
                            <input class="form-control me-2" type="password" placeholder="Password" name="password" required>
                            <button class="btn btn-outline-light" type="submit">Login</button>
                        </form>
                    </li>
                    <li class="nav-item d-lg-none">
                        <a class="nav-link" href="login" style="color: white;">
                            Login
                        </a>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</nav>

<?php foreach ($messages as $message): ?>
<div class="modal fade" id="messageModal<?php echo $message['id']; ?>" tabindex="-1" aria-labelledby="messageModalLabel<?php echo $message['id']; ?>" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="messageModalLabel<?php echo $message['id']; ?>"><?php echo htmlspecialchars($message['subject']); ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><strong>From:</strong> <?php echo htmlspecialchars($message['name']); ?></p>
                <p><?php echo htmlspecialchars($message['message']); ?></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<?php endforeach; ?>


<!-- Include FontAwesome for icons -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/css/all.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.1/js/all.min.js"></script>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).on('click', '.dropdown-item', function (e) {
        var messageId = $(this).data('id'); // Get the message ID from the data attribute

        $.ajax({
            url: 'mark_as_read.php', // Path to your PHP script to mark the message as read
            type: 'POST',
            data: { id: messageId },
            success: function (response) {
                // After marking as read, update the class to remove the bold effect
                $('[data-id="' + messageId + '"]').removeClass('fw-bold');
                
                // Update the notification count
                var currentCount = parseInt($('#notificationsDropdown .badge').text());
                if (currentCount > 0) {
                    $('#notificationsDropdown .badge').text(currentCount - 1);
                    if (currentCount - 1 === 0) {
                        $('#notificationsDropdown .badge').remove(); // Remove badge if no unread messages
                    }
                }
            },
            error: function () {
                console.error('Error occurred while marking message as read');
            }
        });
    });
</script>
