<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Check if the lecturer is logged in
$isLoggedIn = isset($_SESSION['lecturer_id']);
$lecturerId = $isLoggedIn ? $_SESSION['lecturer_id'] : '';

$lecturerName = '';
if ($isLoggedIn) {
    // Database connection
    include '../../config/database.php';

    // Fetch the lecturer's name
    $stmt = $pdo->prepare('SELECT name FROM lecturer_login WHERE id = ?');
    $stmt->execute([$lecturerId]);
    $lecturer = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($lecturer) {
        // Get the first part of the name
        $lecturerName = explode(' ', $lecturer['name'])[0];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lecturer Portal</title>
    <link rel="icon" type="image/png" href="../public/img/sob_logo.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <link rel="stylesheet" href="../public/css/styles.css">
</head>
<body>

    <nav class="navbar navbar-expand-lg navbar-light" style="background-color: #163485;">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php">
                <img src="../img/sob_logo.png" alt="Logo" width="30" height="30" class="d-inline-block align-top">
                <span class="brand-text d-none d-lg-inline" style="color: white;">School of Business Internship</span>
                <span class="brand-text d-lg-none" style="color: white;">SOB-Intern</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <?php if ($isLoggedIn): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="index.php" style="color: white;">Assigned Students</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="region.php" style="color: white;">Select Region</a>
                        </li>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false" style="color: white;">
                                <i class="fas fa-user"></i> <?php echo htmlspecialchars($lecturerName); ?>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                                <!-- <li><a class="dropdown-item" href="../change_password.php">Change Password</a></li> -->
                                <li><a class="dropdown-item" href="logout.php">Logout</a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="login.php" style="color: white;">Login</a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
</body>
</html>
