<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}
include '../includes/header.php';
include '../config/database.php';

// Fetch the transfer request status for the logged-in student
$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare('
    SELECT tr.*, sd.organisation_name AS current_organisation 
    FROM transfer_requests tr 
    JOIN student_details sd ON tr.user_id = sd.user_id 
    WHERE tr.user_id = ?
');
$stmt->execute([$user_id]);
$transfer = $stmt->fetch(PDO::FETCH_ASSOC);

function getStatusWithBox($status) {
    switch ($status) {
        case 'approved':
            return '<span class="badge bg-success"><i class="fas fa-flag"></i> Approved</span>';
        case 'pending':
            return '<span class="badge bg-warning"><i class="fas fa-flag"></i> Pending</span>';
        case 'rejected':
            return '<span class="badge bg-danger"><i class="fas fa-flag"></i> Rejected</span>';
        default:
            return '<span class="badge bg-secondary">' . htmlspecialchars(ucfirst($status)) . '</span>';
    }
}
?>

<div class="container mt-4">
    <h2>Transfer Request Status</h2>
    <?php if ($transfer): ?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Transfer Request Details</h5>
                <p><strong>Current Organisation:</strong> <?php echo htmlspecialchars($transfer['current_organisation']); ?></p>
                <p><strong>New Organisation:</strong> <?php echo htmlspecialchars($transfer['new_organisation_name']); ?></p>
                <p><strong>Reason:</strong> <?php echo htmlspecialchars($transfer['reason']); ?></p>
                <p><strong>Status:</strong> <?php echo getStatusWithBox($transfer['status']); ?></p>
            </div>
        </div>
    <?php else: ?>
        <p>You have not submitted any transfer requests.</p>
    <?php endif; ?>
</div>

<?php include '../includes/footer.php'; ?>
