<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login');
    exit;
}

include '../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $userId = $_SESSION['user_id'];
    
    // Fetch the index_number of the logged-in user
    $stmt = $pdo->prepare('SELECT index_number FROM users WHERE id = ?');
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    $indexNumber = $user['index_number'];
    
    // Sanitize and escape input fields
    $surname = htmlspecialchars(trim($_POST['surname']), ENT_QUOTES, 'UTF-8');
    $firstName = htmlspecialchars(trim($_POST['firstName']), ENT_QUOTES, 'UTF-8');
    $otherNames = htmlspecialchars(trim($_POST['otherNames']), ENT_QUOTES, 'UTF-8');
    $telephone = htmlspecialchars(trim($_POST['telephone']), ENT_QUOTES, 'UTF-8');
    $email = htmlspecialchars(trim($_POST['email']), ENT_QUOTES, 'UTF-8');
    $course = htmlspecialchars(trim($_POST['course']), ENT_QUOTES, 'UTF-8');
    $organisationName = htmlspecialchars(trim($_POST['organisationName']), ENT_QUOTES, 'UTF-8');
    $months = htmlspecialchars(trim($_POST['months']), ENT_QUOTES, 'UTF-8');
    $location = htmlspecialchars(trim($_POST['location']), ENT_QUOTES, 'UTF-8');
    $gpsLocation = htmlspecialchars(trim($_POST['gpsLocation']), ENT_QUOTES, 'UTF-8');
    $region = htmlspecialchars(trim($_POST['region']), ENT_QUOTES, 'UTF-8');
    $district = htmlspecialchars(trim($_POST['district']), ENT_QUOTES, 'UTF-8');
    $filePath = '';

    if (isset($_FILES['acceptanceLetter']) && $_FILES['acceptanceLetter']['error'] === UPLOAD_ERR_OK) {
        $fileTmpPath = $_FILES['acceptanceLetter']['tmp_name'];
        $fileName = $_FILES['acceptanceLetter']['name'];
        $fileSize = $_FILES['acceptanceLetter']['size'];
        $fileType = $_FILES['acceptanceLetter']['type'];
        $fileNameCmps = explode(".", $fileName);
        $fileExtension = strtolower(end($fileNameCmps));

        $allowedfileExtensions = ['pdf', 'jpg', 'jpeg', 'png'];
        if (in_array($fileExtension, $allowedfileExtensions)) {
            $uploadDir = '../uploads/'; // Correct the upload directory
            $newFileName = $indexNumber . '.' . $fileExtension; // Rename file using index_number
            $filePath = $uploadDir . $newFileName;
            if (move_uploaded_file($fileTmpPath, $filePath)) {
                $filePath = $newFileName; // Save only the new file name to the database
            } else {
                header('Location: dashboard.php?status=error_upload');
                exit;
            }
        } else {
            header('Location: dashboard.php?status=invalid_file_type');
            exit;
        }
    }

    $stmt = $pdo->prepare('SELECT * FROM student_details WHERE user_id = ?');
    $stmt->execute([$userId]);
    $existingEntry = $stmt->fetch();

    if ($existingEntry) {
        $status = isset($_POST['submit']) ? 'submitted' : 'saved';
        $stmt = $pdo->prepare('
            UPDATE student_details SET 
                surname = ?, first_name = ?, other_names = ?, telephone = ?, email = ?, course = ?, 
                organisation_name = ?, months = ?, location = ?, gps_location = ?, region = ?, district = ?, 
                acceptance_letter = IF(? = "", acceptance_letter, ?), status = ?
            WHERE user_id = ?
        ');
        $stmt->execute([
            $surname, $firstName, $otherNames, $telephone, $email, $course,
            $organisationName, $months, $location, $gpsLocation, $region, $district,
            $filePath, $filePath, $status, $userId
        ]);
    } else {
        $status = isset($_POST['submit']) ? 'submitted' : 'saved';
        $stmt = $pdo->prepare('
            INSERT INTO student_details 
                (user_id, surname, first_name, other_names, telephone, email, course, organisation_name, months, location, gps_location, region, district, acceptance_letter, status) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ');
        $stmt->execute([
            $userId, $surname, $firstName, $otherNames, $telephone, $email, $course, 
            $organisationName, $months, $location, $gpsLocation, $region, $district, $filePath, $status
        ]);
    }

    if ($status === 'submitted') {
        header('Location: dashboard.php?status=submitted');
        exit;
    } else {
        header('Location: dashboard.php?status=saved');
        exit;
    }
} elseif (isset($_GET['region'])) {
    $region = htmlspecialchars(trim($_GET['region']), ENT_QUOTES, 'UTF-8');
    $stmt = $pdo->prepare('SELECT district FROM districts WHERE region = ?');
    $stmt->execute([$region]);
    $districts = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($districts);
}
?>
