<?php
session_start();
include '../config/database.php';
include '../includes/functions.php'; // Include the functions file to access the updated log_action function

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Sanitize and escape the input fields
    $indexNumber = htmlspecialchars(trim($_POST['indexNumber']), ENT_QUOTES, 'UTF-8');
    $password = htmlspecialchars(trim($_POST['password']), ENT_QUOTES, 'UTF-8');

    // Prepare and execute the query
    $stmt = $pdo->prepare('SELECT * FROM users WHERE index_number = ?');
    $stmt->execute([$indexNumber]);
    $user = $stmt->fetch();

    // Verify the password and start session
    if ($user && password_verify($password, $user['password'])) {
        // Log successful login attempt with detailed information
        log_action(
            $user['id'], 
            $user['index_number'], 
            "Successful login", 
            'users', 
            $user['id'], 
            null, 
            null
        );

        // Set session variables
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['role'] = $user['role'];
        $_SESSION['index_number'] = $user['index_number'];
        
        header('Location: dashboard');
        exit;
    } else {
        // Log failed login attempt
        $user_id = $user ? $user['id'] : null;
        log_action(
            $user_id, 
            $indexNumber, 
            "Failed login attempt", 
            'users', 
            $user_id, 
            null, 
            null
        );

        header('Location: login?error=invalid_credentials');
        exit;
    }
}
?>
